<?php
/**
* @copyright  Copyright (C) 2013- Website Toolbox . All rights reserved.
* @author Team Website Toolbox
* @version 1.0.0
* @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
*/

/*
Plugin Name: Website Toolbox Forum Integrator
Description: The SSO API allows you to integrate your forum's registration, login, and logout process with your website. <a href="#" target="_blank">Setup Instructions...</a>
Author: Team Website Toolbox | <a href="options-general.php?page=websitetoolboxoptions">Settings</a>
Version: 1.0.0
Purpose: Integrate SSO feature with your Joomla website
*/

defined('_JEXEC') or die('Restricted access');
jimport('joomla.plugin.plugin');

// SSO logout from the forum.
if(JFactory::getApplication()->input->get(ssologout)) {
	$inputCookie  = JFactory::getApplication()->input->cookie;
	$logoutToken  = $inputCookie->get($name = 'logoutauthtoken', $defaultValue = null);
	$app = JFactory::getApplication();
	$db = JFactory::getDbo();
	#get data (Forum username, API and URL) from extension table
	$query = "SELECT params FROM `#__extensions` where element = 'websitetoolbox'";
	$db->setQuery($query);
	$toolbox = $db->loadResult();
	#Decode JSON string get from the Joomla Database to get our forum username, api key and forum URL.
	$toolbox = json_decode($toolbox);

	$forumUrl =  trim($toolbox->{forum_url});
	$log_succe = $forumUrl."/register/logout?authtoken=".trim($logoutToken);
	$logImage = "<img src='".$log_succe."' border='0' width='1' height='1' alt=''>";
	JFactory::getApplication()->enqueueMessage('Logout Successfully'.$logImage, 'success');
}


/* If user logged-out from forum then logged-out user from Joomla Website. */
if(JFactory::getApplication()->input->get(action) == 'forumLogout') {
	$logout_url = "Location: " . JURI::root(true) . "/index.php?option=com_users&task=user.logout&";
	$logout_url .=  JSession::getFormToken();
	$logout_url .= "=1&return=";
	header( $logout_url );
}

class plgUserWebsitetoolbox extends JPlugin {

	#cunstructor for intialized joomla site configration
	public function __construct(& $subject, $config) {
		parent::__construct($subject, $config);
		$this->loadLanguage();
	}

	#function check (new or old user) before data insert into database
	public function onUserBeforeSave($user, $isnew, $new) {
		#create an object and make connection with database
		$app = JFactory::getApplication();
		$db = JFactory::getDbo();
		// Create an instance of a default JHttp object.
		$http = JHttpFactory::getHttp();
		JPluginHelper::importPlugin('user');
		#get data (Forum username, API and URL) from extension table
		$query = "SELECT params FROM `#__extensions` where element = 'websitetoolbox'";
		$db->setQuery($query);
		$toolbox = $db->loadResult();
		#Decode JSON string get from the Joomla Database to get our forum username, api key and forum URL.
		$toolbox = json_decode($toolbox);

		$forumUsername = trim($toolbox->{forum_username});
		$forumApi =  trim($toolbox->{forum_api});
		$forumUrl =  trim($toolbox->{forum_url});

		#check username fill from admin section or not
		if($forumUsername == '' || $forumUsername == "Forum API Key") {
			JFactory::getApplication()->enqueueMessage('Website Toolbox Username is unavailable.','error');
			return false;
		} else {
			#check forum API fill from admin section or not
			if($forumApi == '' || $forumApi == "Forum API Key") {
				JFactory::getApplication()->enqueueMessage('Forum API Key is unavailable.','error');
				return false;
			} else {
					#check forum address fill from admin section or not
					if($forumUrl == '' || $forumUrl == "Forum Address") {
						JFactory::getApplication()->enqueueMessage('Forum address is unavailable.','error');
						return false;
					} else {
						// added http:// with the URL if not exists.
						if(!preg_match("~^(?:f|ht)tps?://~i", $forumUrl)) {
							$forumUrl = "http://".$forumUrl;
						}
						// Remove "/" from the end of the URL if exist.
						$url_length = strlen($forumUrl);
						if(substr($forumUrl,$url_length-1,$url_length) == '/') {
							$forumUrl = substr($forumUrl,0,$url_length-1);
						}
						$toolbox = array();
						$toolbox['username']	= $new['username'];
						$toolbox['email'] 		= $new['email'];
						$toolbox['fullname']	= $new['name'];
						$toolbox['password']	= $new['password'];
						#Check username exist or not in the joomla website if user exist then sent request to register user on the Website Toolbox forum.
						if($isnew) {
							$URL = $forumUrl."/register/create_account";
							// Prepare array for create account request.
							$data = array(
								'apikey' => $forumApi,
								'member' => $toolbox['username'],
								'pw'     => $toolbox['password'],
								'email'  => $toolbox['email'],
								'name'   => $toolbox['fullname'],
								'type'   => 'json'
							);
							// sent HTTP post request by Joomla function.
							$response = $http->post($URL, $data);
							$response = json_decode(trim($response->body));
							if($response->{userid}) {
								return true;
							} else if($response->{message}) {
								JFactory::getApplication()->enqueueMessage($response->{message},'error');
								return false;
							}
						}
				}
			}
		}
	}

	/*function for registration a new user on the forum if username available*/
	public function onUserAfterSave($user, $isnew, $success, $msg) {
		$app = JFactory::getApplication();
	}

	#Check before delete user for future reference.
	public function onUserBeforeDelete($user) {
		$app = JFactory::getApplication();
	}
	#Check after delete user for future reference.
	public function onUserAfterDelete($user, $succes, $msg) {
		$app = JFactory::getApplication();
	}

	/*function used for logged-in on the forum if username exist on Joomla site as well as on Website Toolbox forum*/
	public function onUserAfterLogin($options) {
		# get user information from the array.
		$user = $options['user'];
		#create an object to make connection with database
		$app = JFactory::getApplication();
		$db = JFactory::getDbo();
		// Create an instance of a default JHttp object.
		$http = JHttpFactory::getHttp();
		#check user status active or not
		$query_block = "SELECT block FROM `#__users` where username = '".urlencode($user->username)."'";
		$db->setQuery($query_block);
		$toolbox_block = $db->loadResult();
		if($toolbox_block == 0) {
			#get data (Forun username, API and URL) from extension table
			$query = "SELECT params FROM `#__extensions` where element = 'websitetoolbox'";
			$db->setQuery($query);
			$toolbox = $db->loadResult();
			#Decode JSON string get from the Joomla Database to get our forum username, api key and forum URL.
			$toolbox = json_decode($toolbox);

			$forumUsername = trim($toolbox->{forum_username});
			$forumApi =  trim($toolbox->{forum_api});
			$forumUrl =  trim($toolbox->{forum_url});
			#check username fill from admin section or not
			if($forumUsername == '' || $forumUsername == "Website Toolbox Username") {
				return JFactory::getApplication()->enqueueMessage('Forum Username is unavailable.','error');
			} else {
				#check forum API fill from admin section or not
				if($forumApi == '' || $forumApi == "Forum API Key") {
					return JFactory::getApplication()->enqueueMessage('Forum API Key is unavailable.','error');
				} else {
					#check forum address fill from admin section or not
					if($forumUrl == '' || $forumUrl == "Forum Address") {
						return JFactory::getApplication()->enqueueMessage('Forum address is unavailable.','error');
					} else {
						// added http:// with the URL if not exists.
						if(!preg_match("~^(?:f|ht)tps?://~i", $forumUrl)) {
							$forumUrl = "http://".$forumUrl;
						}
						// Remove "/" from the end of the URL if exist.
						$url_length = strlen($forumUrl);
						if(substr($forumUrl,$url_length-1,$url_length) == '/') {
							$forumUrl = substr($forumUrl,0,$url_length-1);
						}

						$username = trim($user->username);
						$email = trim($user->email);
						$URL = $forumUrl."/register/setauthtoken";
						// Prepare array for login request.
						$data = array(
							'apikey' => $forumApi,
							'user'   => $username,
							'email'  => $email,
							'name'	 =>	$user->name,
							'externalUserid'	=>	$user->name,
							'type'   => 'json'
						);

						// sent HTTP post request.
						$response = $http->post($URL, $data);
						$response = json_decode(trim($response->body));
						if($response->{message}) {
							return JFactory::getApplication()->enqueueMessage($response->{message}." You can't login on Forum. Please contact to administrator.",'SOME_ERROR_CODE');
						} else {
							$chatroom_url = htmlentities($response->{chatroom_url});
							if($response->{chatroom_url}) {
								$wtbToken = split("-",$response->{authtoken});
								$authtoken = htmlentities($wtbToken[0]);
								$accesstoken = htmlentities($wtbToken[1]);
							} else {
								$authtoken = htmlentities($response->{authtoken});
							}
							#prepare login image url
							$log_succe = $forumUrl."/register/dologin?authtoken=".trim($authtoken);
							$loginurl = "<img src='".$log_succe."' border='0' width='1' height='1' alt=''>";

							// Prepare login URL for Chat room if "access_token" return
							if($accesstoken) {
								$chatlogin_auth_url = $chatroom_url."/sso/token/login?access_token=".$accesstoken;
								echo '<img src="'.$chatlogin_auth_url.'" border="0" width="0" height="0" alt="">';
							}
							// Set token into a cookie for logout.
							$inputCookie  = JFactory::getApplication()->input->cookie;
							$inputCookie->input->cookie->set('logoutauthtoken', $value = trim($authtoken), $expire = 0, $inputCookie->get('cookie_path', '/'), $inputCookie->get('cookie_domain'), $inputCookie->isSSLConnection());
							#prepare logout image url
							$forumLogoutUrl  = $forumUrl."/register/logout?authtoken=".trim($authtoken);
							$session = JFactory::getSession();
							// Create session varible for logout URL as well as set it's expiration time as 30 days.
							$session->set('wtbLogoutUrl', $forumLogoutUrl);
							$expire=time()+60*60*24*30;
							// Set cookie.
							setcookie("userlogout", $forumLogoutUrl, $expire);
							return JFactory::getApplication()->enqueueMessage('You have successfully logged-in on Websitetoolbox Forum as well.'.$loginurl,'success');
						}
					}
				}
			}
		}
	}

	#Function for logged-out from Website Toolbox forum
	public function onUserAfterLogout($user, $options = array()) {
		JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_users&view=login&ssologout=1', false));
	}
}

?>
